local menuItem = 1
local numMenuItems = 2

local machineProfile = PROFILEMAN:GetMachineProfile()
local numLocalProfiles = PROFILEMAN:GetNumLocalProfiles()
local profiles = {}
for i=1,numLocalProfiles do
	table.insert(profiles,PROFILEMAN:GetLocalProfileFromIndex(i-1))
end

local c

return Def.ActorFrame{
	InitCommand=function(self) c = self:GetChildren() end;
	Def.Actor{
		Name="MenuControl";
		BeginCommand=function(self)
			c.Choice1:playcommand("GainFocus")
			c.Choice2:playcommand("LoseFocus")
		end;
		MenuInputMessageCommand=function(self,param)
			if param.Input == "Start" then
				local profile = (menuItem == 1) and machineProfile or profiles[1]
				if profile then
					local userTable = profile:GetUserTable()
					if userTable then
						-- booleans must be converted to strings (or other representations)
						Trace("setting sm5te-labo")
						userTable["sm5te-labo"] = tostring(true)

						Trace("setting ScreenFilterIntensity")
						userTable["ScreenFilterIntensity"] = 1.0
						Trace("ScreenFilterIntensity = "..userTable["ScreenFilterIntensity"])

						Trace("setting Stringy")
						userTable["Stringy"] = "wrapped around my fingy"

						-- tables throw a new tag into the mix. the below table...
						-- <settings A="hello" B="World" C="waka flocka flame"></settings>
						Trace("setting settings (table)")
						userTable["settings"] = {
							A = "hello",
							B = "World",
							C = "waka flocka flame",
						}

						-- you can't put pure functions in a usertable; you'll need to
						-- put them in as a string and then find a way to re-load it.
						Trace("setting set1024 (function)")
						userTable["set1024"] = [[function() print("hello world 1024") end]]

						local pid = PROFILEMAN:GetLocalProfileIDFromIndex(0)
						PROFILEMAN:SaveLocalProfile(pid)
						SCREENMAN:SystemMessage( string.format("wrote a bunch of stuff to %s's user table.",profile:GetDisplayName()) )
					else
						SCREENMAN:SystemMessage("can't write to the user table. :|")
					end
				else
					-- error
				end
			else
				if param.Input == "Up" then
					if menuItem - 1 <= 0 then
						menuItem = numMenuItems
					else
						menuItem = menuItem - 1
					end
					MESSAGEMAN:Broadcast("PlayerChangedFocus",{Player = param.Player});
				elseif param.Input == "Down" then
					if menuItem + 1 > numMenuItems then
						menuItem = 1
					else
						menuItem = menuItem + 1
					end
					MESSAGEMAN:Broadcast("PlayerChangedFocus",{Player = param.Player});
				else
					-- do nothing yet
				end
			end
		end;
		MenuUpP1MessageCommand=function(self) MESSAGEMAN:Broadcast("MenuInput", { Player = PLAYER_1, Input = "Up", }); end;
		MenuUpP2MessageCommand=function(self) MESSAGEMAN:Broadcast("MenuInput", { Player = PLAYER_2, Input = "Up", }); end;
		MenuDownP1MessageCommand=function(self) MESSAGEMAN:Broadcast("MenuInput", { Player = PLAYER_1, Input = "Down", }); end;
		MenuDownP2MessageCommand=function(self) MESSAGEMAN:Broadcast("MenuInput", { Player = PLAYER_2, Input = "Down", }); end;
		MenuLeftP1MessageCommand=function(self) MESSAGEMAN:Broadcast("MenuInput", { Player = PLAYER_1, Input = "Left", }); end;
		MenuLeftP2MessageCommand=function(self) MESSAGEMAN:Broadcast("MenuInput", { Player = PLAYER_2, Input = "Left", }); end;
		MenuRightP1MessageCommand=function(self) MESSAGEMAN:Broadcast("MenuInput", { Player = PLAYER_1, Input = "Right", }); end;
		MenuRightP2MessageCommand=function(self) MESSAGEMAN:Broadcast("MenuInput", { Player = PLAYER_2, Input = "Right", }); end;
		MenuStartP1MessageCommand=function(self) MESSAGEMAN:Broadcast("MenuInput", { Player = PLAYER_1, Input = "Start", }); end;
		MenuStartP2MessageCommand=function(self) MESSAGEMAN:Broadcast("MenuInput", { Player = PLAYER_2, Input = "Start", }); end;
		-- codes
		CodeMessageCommand=function(self,param)
			MESSAGEMAN:Broadcast("MenuInput", { Player = param.PlayerNumber, Input = param.Name, })
		end;
	};

	LoadFont("_smallcaps 8px")..{
		Name="Choice1";
		Text="Machine Profile";
		InitCommand=cmd(CenterX;y,SCREEN_CENTER_Y-32);
		GainFocusCommand=cmd(diffuse,color("1,1,1,1"));
		LoseFocusCommand=cmd(diffuse,color("0.6,0.6,0.6,1"));
		PlayerChangedFocusMessageCommand=function(self)
			self:playcommand( menuItem == 1 and "GainFocus" or "LoseFocus" )
		end;
	};
	-- presumptious but I'm the only person using this theme; fuck you.
	LoadFont("_smallcaps 8px")..{
		Name="Choice2";
		Text=profiles[1]:GetDisplayName();
		InitCommand=cmd(CenterX;y,SCREEN_CENTER_Y-16);
		GainFocusCommand=cmd(diffuse,color("1,1,1,1"));
		LoseFocusCommand=cmd(diffuse,color("0.6,0.6,0.6,1"));
		PlayerChangedFocusMessageCommand=function(self)
			self:playcommand( menuItem == 2 and "GainFocus" or "LoseFocus" )
		end;
	};
};